/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class VideoPoker
extends MIDlet
implements CommandListener {
    private Command againCommand;
    private Command dealCommand;
    private Command exitCommand;
    private Command startCommand;
    private Command quitCommand;
    private Display display;
    private MainScreen mainscreen;
    private ScoreScreen scorescreen;
    private TitleScreen titlescreen;
    private Image heart;
    private Image diamond;
    private Image spade;
    private Image club;
    private Image back;
    private Image title;
    private Image arrow;
    private final int fwidth;
    private final int fheight;
    private static int width;
    private static int height;
    private static int ox;
    private static int oy;
    private static int hcenter;
    private final Font fp = Font.getFont((int)64, (int)0, (int)0);
    private final Font fb = Font.getFont((int)64, (int)1, (int)0);
    private final Font fs = Font.getFont((int)64, (int)0, (int)8);
    private final int BET;
    private final int HOLDING;
    private final int CALL;
    private final int WIN;
    private final int LOSE;
    private final int BUSTED;
    private final int SPADES;
    private final int DIAMONDS;
    private final int CLUBS;
    private final int HEARTS;
    private final int PAIR;
    private final int TWOPAIR;
    private final int THREE;
    private final int STRAIGHT;
    private final int FLUSH;
    private final int FULLHOUSE;
    private final int FOUR;
    private final int STRAIGHTFLUSH;
    private final int ROYALFLUSH;
    private final String[] cardRank = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K", "A"};
    private final int LGREEN;
    private final int DGREEN;
    private final int RED;
    private final int ORANGE;
    private final int YELLOW;
    private final int WHITE;
    private final int BLACK;
    private int bank;
    private int bet;
    private int lastbet;
    private int[][] hand = new int[5][2];
    private int[][] deck = new int[52][2];
    private int[][] currentDeck = new int[10][2];
    private Random shuffle = new Random();
    private Pauser pauser = new Pauser();
    private boolean[] shown = new boolean[5];
    private boolean[] held = new boolean[5];
    private int arrowpos;
    private int cardpos;
    private boolean dealing;
    private int mode;
    private int modifier;
    private String message;
    private int[] tempcard;
    private int card;
    private int[][] temphand;
    private Image cardimg;

    public VideoPoker() {
        this.fwidth = 96;
        this.fheight = 100;
        this.BET = 0;
        this.HOLDING = 1;
        this.CALL = 2;
        this.WIN = 3;
        this.LOSE = 4;
        this.BUSTED = 5;
        this.SPADES = 0;
        this.DIAMONDS = 1;
        this.CLUBS = 2;
        this.HEARTS = 3;
        this.PAIR = 2;
        this.TWOPAIR = 4;
        this.THREE = 6;
        this.STRAIGHT = 10;
        this.FLUSH = 15;
        this.FULLHOUSE = 20;
        this.FOUR = 30;
        this.STRAIGHTFLUSH = 50;
        this.ROYALFLUSH = 100;
        this.LGREEN = 47872;
        this.DGREEN = 25600;
        this.RED = 0xFF0000;
        this.ORANGE = 16748800;
        this.YELLOW = 0xFFFF00;
        this.WHITE = 0xFFFFFF;
        this.BLACK = 0;
        this.display = Display.getDisplay((MIDlet)this);
        this.mainscreen = new MainScreen();
        this.scorescreen = new ScoreScreen();
        this.titlescreen = new TitleScreen();
        width = this.mainscreen.getWidth();
        height = this.mainscreen.getHeight();
        ox = (width - 96) / 2;
        oy = (height - 100) / 2;
        hcenter = width / 2;
        try {
            this.heart = Image.createImage((String)"/heart.png");
            this.spade = Image.createImage((String)"/spade.png");
            this.club = Image.createImage((String)"/club.png");
            this.diamond = Image.createImage((String)"/diamond.png");
            this.back = Image.createImage((String)"/back.png");
            this.title = Image.createImage((String)"/videopokertitle.png");
            this.arrow = Image.createImage((String)"/arrow.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.againCommand = new Command("Again", 1, 1);
        this.dealCommand = new Command("Deal", 1, 1);
        this.exitCommand = new Command("Exit", 7, 1);
        this.startCommand = new Command("Start", 1, 1);
        this.quitCommand = new Command("Quit", 1, 1);
        this.initGame();
    }

    public void startApp() throws MIDletStateChangeException {
        this.display.setCurrent((Displayable)this.titlescreen);
        this.addBeginCommands();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    private void initGame() {
        this.bank = 20;
        this.bet = 1;
        this.lastbet = 1;
        this.initDeck();
        this.initRound();
    }

    private void initDeck() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 13) {
                this.deck[n][0] = n2;
                this.deck[n][1] = n3++;
                ++n;
            }
            ++n2;
        }
    }

    private void initRound() {
        this.shuffleDeck();
        this.resetHeld();
        this.hand = null;
        this.dealing = false;
        this.arrowpos = 12;
        this.cardpos = 0;
        this.modifier = 0;
        this.mode = 0;
        this.bet = this.lastbet;
        this.message = "";
    }

    private void shuffleDeck() {
        int n = this.deck.length;
        this.currentDeck = new int[10][2];
        int[] nArray = new int[10];
        int n2 = 0;
        while (n2 < 10) {
            do {
                this.card = Math.abs(this.shuffle.nextInt()) % n;
            } while (this.getOcc(nArray, this.card) > 0);
            this.currentDeck[n2][0] = this.deck[this.card][0];
            this.currentDeck[n2][1] = this.deck[this.card][1];
            nArray[n2] = this.card;
            ++n2;
        }
    }

    private void resetHeld() {
        int n = 0;
        while (n < 5) {
            this.held[n] = false;
            ++n;
        }
        this.arrowpos = 12;
        this.cardpos = 0;
    }

    private int[][] dealCards() {
        this.temphand = new int[5][2];
        int n = 0;
        while (n < 5) {
            if (this.held[n]) {
                this.temphand[n][0] = this.hand[n][0];
                this.temphand[n][1] = this.hand[n][1];
                this.shown[n] = true;
            } else {
                this.temphand[n][0] = this.currentDeck[0][0];
                this.temphand[n][1] = this.currentDeck[0][1];
                int n2 = 1;
                while (n2 < 10) {
                    this.currentDeck[n2 - 1] = this.currentDeck[n2];
                    ++n2;
                }
                this.shown[n] = false;
            }
            ++n;
        }
        return this.temphand;
    }

    private void checkForWin() {
        this.message = "Bad Luck!";
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        int n = 0;
        while (n < 5) {
            nArray[n] = this.hand[n][0];
            nArray2[n] = this.hand[n][1];
            ++n;
        }
        this.mode = 4;
        this.checkPair(nArray2);
        this.checkTwoPair(nArray2);
        this.checkThree(nArray2);
        this.checkStraight(nArray2);
        this.checkFlush(nArray);
        this.checkFullHouse(nArray2);
        this.checkFour(nArray2);
        this.checkStraightFlush(nArray2, nArray);
        this.checkRoyalFlush(nArray2, nArray);
        this.bank += this.bet * this.modifier;
        if (this.bank < 1) {
            this.bank = 0;
            this.bet = 0;
            this.mode = 5;
            this.addAgainCommands();
        }
        this.lastbet = this.bet;
        this.bet = 0;
        this.mainscreen.repaint();
    }

    private void checkPair(int[] nArray) {
        int n = 0;
        while (n < 5) {
            if (nArray[n] > 8 && this.getOcc(nArray, nArray[n]) > 1) {
                this.message = "Pair!";
                this.modifier = 2;
                this.mode = 3;
                break;
            }
            ++n;
        }
    }

    private void checkTwoPair(int[] nArray) {
        int n = 0;
        block0: while (n < 5) {
            if (this.getOcc(nArray, nArray[n]) > 1) {
                int n2 = 0;
                while (n2 < 5) {
                    if (this.getOcc(nArray, nArray[n2]) > 1 && nArray[n2] != nArray[n]) {
                        this.message = "Two Pair!";
                        this.modifier = 4;
                        this.mode = 3;
                        break block0;
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
    }

    private void checkThree(int[] nArray) {
        int n = 0;
        while (n < 5) {
            if (this.getOcc(nArray, nArray[n]) > 2) {
                this.message = "Three Of A Kind!";
                this.modifier = 6;
                this.mode = 3;
                break;
            }
            ++n;
        }
    }

    private void checkStraight(int[] nArray) {
        int n = 12;
        int n2 = 0;
        while (n2 < 5) {
            if (nArray[n2] < n) {
                n = nArray[n2];
            }
            ++n2;
        }
        if (n < 9) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < 5) {
                if (this.getOcc(nArray, n) != 1) break;
                ++n3;
                ++n;
                ++n4;
            }
            if (n3 == 5) {
                this.message = "Straight!";
                this.modifier = 10;
                this.mode = 3;
            }
        }
    }

    private void checkFlush(int[] nArray) {
        int n = 0;
        while (n < 5) {
            if (this.getOcc(nArray, nArray[n]) == 5) {
                this.message = "Flush!";
                this.modifier = 15;
                this.mode = 3;
                break;
            }
            ++n;
        }
    }

    private void checkFullHouse(int[] nArray) {
        int n = -1;
        int n2 = 0;
        while (n2 < 5) {
            if (this.getOcc(nArray, nArray[n2]) == 3) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1) {
            int n3 = 0;
            while (n3 < 5) {
                if (n3 != n && this.getOcc(nArray, nArray[n3]) == 2) {
                    this.message = "Full House!";
                    this.modifier = 20;
                    this.mode = 3;
                    break;
                }
                ++n3;
            }
        }
    }

    private void checkFour(int[] nArray) {
        int n = 0;
        while (n < 5) {
            if (this.getOcc(nArray, nArray[n]) > 3) {
                this.message = "Four Of A Kind!";
                this.modifier = 30;
                this.mode = 3;
                break;
            }
            ++n;
        }
    }

    private void checkStraightFlush(int[] nArray, int[] nArray2) {
        if (this.modifier == 15) {
            this.checkStraight(nArray);
            if (this.modifier == 10) {
                this.message = "Straight Flush!";
                this.modifier = 50;
                this.mode = 3;
            }
        }
    }

    private void checkRoyalFlush(int[] nArray, int[] nArray2) {
        if (this.modifier == 50 && nArray[0] == 8) {
            this.message = "!!! Royal Flush !!!";
            this.modifier = 100;
            this.mode = 3;
        }
    }

    private int getOcc(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4] == n) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.againCommand) {
            if (this.mode == 5) {
                this.initGame();
            } else {
                this.initRound();
                if (this.bank - this.bet < 0) {
                    this.bet = this.bank;
                    this.bank = 0;
                } else {
                    this.bank -= this.bet;
                }
            }
            this.removeAgainCommands();
            this.addDealCommands();
            this.mainscreen.repaint();
        }
        if (command == this.dealCommand) {
            this.removeDealCommands();
            try {
                this.hand = this.dealCards();
            }
            catch (Exception exception) {
                this.db("ex:\n" + exception);
            }
            this.dealing = true;
            this.pauser = new Pauser();
            this.pauser.start();
        }
        if (command == this.exitCommand) {
            this.pauser = null;
            this.destroyApp(false);
            this.notifyDestroyed();
        }
        if (command == this.startCommand) {
            this.removeBeginCommands();
            this.initGame();
            this.display.setCurrent((Displayable)this.mainscreen);
            this.addDealCommands();
        }
        if (command == this.quitCommand) {
            this.removeDealCommands();
            this.display.setCurrent((Displayable)this.titlescreen);
            this.addBeginCommands();
        }
    }

    private void addBeginCommands() {
        this.titlescreen.addCommand(this.startCommand);
        this.titlescreen.addCommand(this.exitCommand);
        this.titlescreen.setCommandListener(this);
    }

    private void removeBeginCommands() {
        this.titlescreen.removeCommand(this.startCommand);
        this.titlescreen.removeCommand(this.exitCommand);
    }

    private void addDealCommands() {
        this.mainscreen.addCommand(this.dealCommand);
        this.mainscreen.addCommand(this.quitCommand);
        this.mainscreen.setCommandListener(this);
    }

    private void removeDealCommands() {
        this.mainscreen.removeCommand(this.dealCommand);
        this.mainscreen.removeCommand(this.quitCommand);
        this.mainscreen.removeCommand(this.againCommand);
    }

    private void addAgainCommands() {
        this.mainscreen.addCommand(this.againCommand);
        this.mainscreen.addCommand(this.quitCommand);
    }

    private void removeAgainCommands() {
        this.mainscreen.removeCommand(this.againCommand);
        this.mainscreen.removeCommand(this.quitCommand);
    }

    private void dbCards(int[][] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.db(n + ": " + nArray[n][0] + "," + nArray[n][1]);
            ++n;
        }
    }

    public void db(String string) {
        System.out.println(string);
    }

    class TitleScreen
    extends Canvas {
        private int x;

        TitleScreen() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(25600);
            graphics.fillRect(0, 0, width, height);
            graphics.drawImage(VideoPoker.this.title, ox, oy + 5, 20);
            graphics.setColor(0xFFFFFF);
            graphics.fillRoundRect(ox + 12, oy + 22, 72, 19, 3, 3);
            this.x = ox + 16;
            graphics.drawImage(VideoPoker.this.heart, this.x, oy + 24, 20);
            graphics.drawImage(VideoPoker.this.spade, this.x + 16, oy + 24, 20);
            graphics.drawImage(VideoPoker.this.diamond, this.x + 32, oy + 24, 20);
            graphics.drawImage(VideoPoker.this.club, this.x + 48, oy + 24, 20);
            graphics.setColor(47872);
            graphics.fillRoundRect(ox + 2, oy + 81, width - 4, 16, 3, 3);
            graphics.setColor(0xFFFF00);
            graphics.setFont(VideoPoker.this.fs);
            graphics.drawString("Press Fire to", hcenter, oy + 50, 17);
            graphics.drawString("view scoring", hcenter, oy + 60, 17);
            graphics.drawString("www.zeroindex.co.uk", hcenter, oy + 81, 17);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 8) {
                VideoPoker.this.display.setCurrent((Displayable)VideoPoker.this.scorescreen);
            }
        }
    }

    class ScoreScreen
    extends Canvas {
        private int x;
        private int y;

        ScoreScreen() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(25600);
            graphics.fillRect(0, 0, width, height);
            graphics.setColor(47872);
            graphics.fillRoundRect(ox + 2, oy + 2, 92, 96, 8, 8);
            graphics.setColor(0xFFFFFF);
            this.x = ox + 6;
            this.y = oy + 1;
            graphics.drawString("Royal Flush", this.x, this.y, 20);
            graphics.drawString("Straight Flush", this.x, this.y + 10, 20);
            graphics.drawString("Four Of Kind", this.x, this.y + 20, 20);
            graphics.drawString("Full House", this.x, this.y + 30, 20);
            graphics.drawString("Flush", this.x, this.y + 40, 20);
            graphics.drawString("Straight", this.x, this.y + 50, 20);
            graphics.drawString("Three Of Kind", this.x, this.y + 60, 20);
            graphics.drawString("Two Pair", this.x, this.y + 70, 20);
            graphics.drawString("Pair (J+)", this.x, this.y + 80, 20);
            this.x = ox + 96 - 4;
            graphics.setColor(0xFFFF00);
            graphics.drawString("100", this.x, this.y, 24);
            graphics.drawString("50", this.x, this.y + 10, 24);
            graphics.drawString("30", this.x, this.y + 20, 24);
            graphics.drawString("20", this.x, this.y + 30, 24);
            graphics.drawString("15", this.x, this.y + 40, 24);
            graphics.drawString("10", this.x, this.y + 50, 24);
            graphics.drawString("6", this.x, this.y + 60, 24);
            graphics.drawString("4", this.x, this.y + 70, 24);
            graphics.drawString("2", this.x, this.y + 80, 24);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 8) {
                VideoPoker.this.display.setCurrent((Displayable)VideoPoker.this.titlescreen);
            }
        }
    }

    class MainScreen
    extends Canvas {
        MainScreen() {
        }

        public void paint(Graphics graphics) {
            try {
                graphics.setColor(25600);
                graphics.fillRect(0, 0, width, height);
                graphics.setColor(47872);
                graphics.fillRoundRect(ox + 2, oy + 37, 92, 41, 3, 3);
                if (VideoPoker.this.mode == 0 && !VideoPoker.this.dealing) {
                    graphics.setFont(VideoPoker.this.fp);
                    graphics.setColor(0xFF0000);
                    graphics.fillRoundRect(ox + 96 - 25, oy + 16, 22, 14, 3, 3);
                    this.paintMessage(graphics, 0xFFFFFF, 47872, "Place Bet");
                }
                graphics.setFont(VideoPoker.this.fb);
                graphics.setColor(0xFFFF00);
                graphics.drawString("Bank", ox + 4, oy, 20);
                graphics.drawString("Bet", ox + 96 - 4, oy, 24);
                graphics.setFont(VideoPoker.this.fp);
                graphics.drawString("$" + VideoPoker.this.bank, ox + 4, oy + 15, 20);
                graphics.drawString("$" + VideoPoker.this.bet, ox + 96 - 4, oy + 15, 24);
                graphics.setFont(VideoPoker.this.fp);
                int n = ox + 4;
                int n2 = 0;
                while (n2 < 5) {
                    graphics.setColor(0xFFFFFF);
                    int n3 = oy + 40;
                    if (VideoPoker.this.hand != null) {
                        VideoPoker.this.cardimg = this.getCardImage(n2);
                        if (VideoPoker.this.cardimg != null && VideoPoker.this.shown[n2]) {
                            if (VideoPoker.this.held[n2] && VideoPoker.this.mode == 1) {
                                n3 += 5;
                            }
                            graphics.fillRoundRect(n, n3, 16, 30, 3, 3);
                            graphics.drawImage(VideoPoker.this.cardimg, n + 1, n3 + 1, 20);
                            graphics.setColor(0);
                            graphics.drawString(VideoPoker.this.cardRank[VideoPoker.this.hand[n2][1]], n + 8, n3 + 16, 17);
                        } else {
                            graphics.fillRoundRect(n, n3, 16, 30, 3, 3);
                            graphics.drawImage(VideoPoker.this.back, n + 1, n3 + 1, 20);
                        }
                    } else {
                        graphics.fillRoundRect(n, n3, 16, 30, 3, 3);
                        graphics.drawImage(VideoPoker.this.back, n + 1, n3 + 1, 20);
                    }
                    n += 18;
                    ++n2;
                }
                if (VideoPoker.this.mode == 1 && !VideoPoker.this.dealing) {
                    graphics.setFont(VideoPoker.this.fb);
                    graphics.setColor(0xFFFFFF);
                    graphics.drawImage(VideoPoker.this.arrow, ox + VideoPoker.this.arrowpos, oy + 82, 17);
                } else if (VideoPoker.this.mode == 3 && !VideoPoker.this.dealing) {
                    this.paintMessage(graphics, 0, 0xFFFF00, VideoPoker.this.message);
                } else if (VideoPoker.this.mode == 4 && !VideoPoker.this.dealing) {
                    this.paintMessage(graphics, 0, 16748800, VideoPoker.this.message);
                } else if (VideoPoker.this.mode == 5 && !VideoPoker.this.dealing) {
                    this.paintMessage(graphics, 0xFFFFFF, 0xFF0000, "Busted!");
                }
            }
            catch (Exception exception) {
                VideoPoker.this.db("Exception in mainscreen paint:\n" + exception);
            }
        }

        private void paintMessage(Graphics graphics, int n, int n2, String string) {
            graphics.setColor(n2);
            graphics.fillRoundRect(ox + 2, oy + 80, 92, 16, 3, 3);
            graphics.setColor(n);
            graphics.drawString(string, hcenter, oy + 80, 17);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 1 && VideoPoker.this.mode == 0) {
                if (VideoPoker.this.bet + 1 < 51 && VideoPoker.this.bank - 1 > -1) {
                    VideoPoker.this.bet += 1;
                    VideoPoker.this.bank -= 1;
                    VideoPoker.this.mainscreen.repaint();
                }
            } else if (n2 == 6 && VideoPoker.this.mode == 0) {
                if (VideoPoker.this.bet - 1 > 0) {
                    VideoPoker.this.bet -= 1;
                    VideoPoker.this.bank += 1;
                    VideoPoker.this.mainscreen.repaint();
                }
            } else if (n2 == 2) {
                VideoPoker.this.arrowpos = VideoPoker.this.arrowpos - 18 < 12 ? 84 : VideoPoker.this.arrowpos - 18;
                VideoPoker.this.cardpos = VideoPoker.this.cardpos - 1 < 0 ? 4 : VideoPoker.this.cardpos - 1;
                this.repaint();
            } else if (n2 == 5) {
                VideoPoker.this.arrowpos = VideoPoker.this.arrowpos + 18 > 84 ? 12 : VideoPoker.this.arrowpos + 18;
                VideoPoker.this.cardpos = VideoPoker.this.cardpos + 1 > 4 ? 0 : VideoPoker.this.cardpos + 1;
                this.repaint();
            } else if (n2 == 8 && VideoPoker.this.mode == 1) {
                ((VideoPoker)VideoPoker.this).held[((VideoPoker)VideoPoker.this).cardpos] = !VideoPoker.this.held[VideoPoker.this.cardpos];
                this.repaint();
            }
        }

        private Image getCardImage(int n) {
            VideoPoker.this.cardimg = null;
            if (VideoPoker.this.hand[n][0] == 3) {
                VideoPoker.this.cardimg = VideoPoker.this.heart;
            } else if (VideoPoker.this.hand[n][0] == 0) {
                VideoPoker.this.cardimg = VideoPoker.this.spade;
            } else if (VideoPoker.this.hand[n][0] == 1) {
                VideoPoker.this.cardimg = VideoPoker.this.diamond;
            } else if (VideoPoker.this.hand[n][0] == 2) {
                VideoPoker.this.cardimg = VideoPoker.this.club;
            }
            return VideoPoker.this.cardimg;
        }
    }

    class Pauser
    extends Thread {
        Pauser() {
        }

        public void run() {
            int n = 0;
            while (n < 5) {
                VideoPoker.this.mainscreen.repaint();
                if (!VideoPoker.this.shown[n]) {
                    this.pause(350L);
                }
                ((VideoPoker)VideoPoker.this).shown[n] = true;
                VideoPoker.this.mainscreen.repaint();
                ++n;
            }
            VideoPoker.this.dealing = false;
            if (VideoPoker.this.mode == 0) {
                VideoPoker.this.mode = 1;
                VideoPoker.this.addDealCommands();
                VideoPoker.this.mainscreen.repaint();
            } else if (VideoPoker.this.mode == 1) {
                VideoPoker.this.mode = 2;
                VideoPoker.this.resetHeld();
                VideoPoker.this.addAgainCommands();
                VideoPoker.this.mainscreen.repaint();
                VideoPoker.this.checkForWin();
            }
        }

        private void pause(long l) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

